/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.validate.NumberRange;
import com.mrcrayfish.framework.api.config.validate.Validator;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class LongProperty
extends AbstractProperty<Long> {
    LongProperty(long defaultValue, Validator<Long> validator) {
        super(defaultValue, (config, path) -> config.getLongOrElse(path, defaultValue), validator);
    }

    @Override
    public class_9139<ByteBuf, Long> streamCodec() {
        return class_9135.field_48551;
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.define(this.data.getPath(), this.defaultValue, o -> {
            if (o instanceof Long || o instanceof Integer) {
                Long value = ((Number)o).longValue();
                return this.isValid(value);
            }
            return false;
        });
    }

    @Override
    public boolean isValid(Long value) {
        return value != null && (this.validator == null || this.validator.test(value));
    }

    public static LongProperty create(long defaultValue) {
        return LongProperty.create(defaultValue, null);
    }

    public static LongProperty create(long defaultValue, long minValue, long maxValue) {
        return LongProperty.create(defaultValue, new NumberRange<Long>(minValue, maxValue));
    }

    public static LongProperty create(long defaultValue, Validator<Long> validator) {
        return new LongProperty(defaultValue, validator);
    }
}

